"use client";
import React, { useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faPlus, faMinus } from "@fortawesome/free-solid-svg-icons";

const Faq = () => {

  const [activeIndex, setActiveIndex] = useState(null);

  const faqData = [
    {
      heading: "Brandon Bames – Make It Unique",
      text: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    },
    {
      heading: "Brandon Bames – Make It Unique",
      text: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    },
    {
      heading: "Brandon Bames – Make It Unique",
      text: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    },
    {
      heading: "Brandon Bames – Make It Unique",
      text: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    },
    {
      heading: "Brandon Bames – Make It Unique",
      text: "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    },
  ];

  const toggleFAQ = (index) => {
    setActiveIndex(index === activeIndex ? null : index);
  };

  return (
    <div>
      <div className="relative">
        <img
          src="/assets/home/homeCard.png"
          alt="Home-Card"
          className="w-full max-h-[500px] bg-cover"
        />
        <div className="absolute top-0 left-0 h-full w-full flex justify-center items-center bg-black opacity-60">
          <div className="flex flex-col  gap-4">
            <p className="text-white font-medium text-3xl text-center">FAQs</p>
          </div>
        </div>
      </div>
      <div className="max-w-7xl mx-auto px-6">
        <div className="flex flex-col items-center gap-3 py-8">
          <h1 className="text-black text-3xl font-semibold">
            Frequently Asked Questions
          </h1>
          <p className="text-sm font-normal text-darkgrey text-center max-w-[600px]">
            Lorem Ipsum is simply dummy text of the printing and typesetting
            industry. Lorem Ipsum has been the industry's standard dummy text
            ever since the 1500s
          </p>
        </div>

        <div className="flex flex-col gap-4 pb-12">
          {faqData.map((faq, index) => (
            <div
              key={index}
              className={`flex flex-col gap-2 bg-[#EFF4FF] p-4 rounded-md ${
                activeIndex === index ? "border border-[#2B59CE]" : ""
              }`}
            >
              <div
                className="flex justify-between py-1"
                onClick={() => toggleFAQ(index)}
              >
                <h2 className="text-black font-medium text-xl">
                  {faq?.heading}
                </h2>
                <FontAwesomeIcon
                  icon={activeIndex === index ? faMinus : faPlus}
                  className={`h-5 w-5 ${
                    activeIndex === index ? "text-golden" : "text-[#A9A7B1]"
                  }`}
                />
              </div>
              {activeIndex === index && (
                <div className="">
                  <div className="bg-[#A2A3AC] opacity-30 h-[2px] mb-2"></div>
                  <p className="text-darkgrey font-normal text-lg">
                    {faq?.text}
                  </p>
                </div>
              )}
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default Faq;