import { API_END_POINTS } from "@/services/ApiEndpoints";
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

const initialState = {
  topVideos: null,
  isLoading: false,
};

// fetch calls
export const topVideos = createAsyncThunk(
  "topVideos/topVideos",
  async (_, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(API_END_POINTS.getTopVideos, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });

      if (!response.ok) throw new Error("Failed to fetch course progress");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);

export const topVideosSlice = createSlice({
  name: "topVideos",
  initialState,
  reducers: {
    getTopVideos: (state, action) => {
      state.topVideos = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(topVideos.fulfilled, (state, action) => {
      state.topVideos = action.payload;
      state.isLoading = false;
    });
    builder.addCase(topVideos.pending, (state, action) => {
      state.isLoading = true;
    });
  },
});

export default topVideosSlice.reducer;
