import { API_END_POINTS } from "@/services/ApiEndpoints";
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";


const initialState = {
  upComingVideo:  null,
  isLoading: false,
};

// fetch calls
export const upComingVideo = createAsyncThunk(
    "upComingVideo/upComingVideo",
    async (_, { getState }) => {
      const token = getState().auth?.token;

  
      try {
        const response = await fetch(API_END_POINTS.getUpComingVideo, {
          headers: {
            Authorization: `Bearer ${token}`,
          },

        });
  
        if (!response.ok) throw new Error("Failed to fetch course progress");
        return await response.json();
      } catch (error) {
        throw error;
      }
    }
  );

export const upComingVideoSlice = createSlice({
  name: "upComingVideo",
  initialState,
  reducers: {
    getUpComingVideo: (state, action) => {
      state.upComingVideo = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(upComingVideo.fulfilled, (state, action) => {
      state.upComingVideo = action.payload;
      state.isLoading = false;
    });
    builder.addCase(upComingVideo.pending, (state, action) => {
      state.isLoading = true;
    });
  },

});


export default upComingVideoSlice.reducer;
