"use client";
import React, { useEffect, useState } from "react";
import {
  useGetEducationQuery,
  useGetExperienceQuery,
  useGetUserDetailQuery,
} from "@/services/Api";
import Link from "next/link";
import AssignTasks from "../assignTasks/assignTasks";
import { Pie } from "react-chartjs-2";
import { Chart as ChartJS, ArcElement, Tooltip, Legend } from "chart.js";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faPencil } from "@fortawesome/free-solid-svg-icons";
import Header from "../header/header";
import EnrolledDashboardCourses from "../enrolled-dashboard-courses/enrolled-dashboard-courses";
import TopVideos from "../topVideos/topVideos";
import UpComingVideos from "../upComingVideos/upComingVideos";
ChartJS.register(ArcElement, Tooltip, Legend);

const Dashoard = () => {

  const [percentage, setPercentage] = useState(0);
  const { data: getEducation, refetch: getEducationRefetch } =
    useGetEducationQuery();

  const { data: getExperience, refetch: getExperienceRefetch } =
    useGetExperienceQuery();

  const { data: getUserDetail, refetch: getUserDetailRefetch } =
    useGetUserDetailQuery();

  useEffect(() => {
    Promise.all([
      getEducationRefetch(),
      getExperienceRefetch(),
      getUserDetailRefetch(),
    ]);
  }, []);

  const pieChartData = [
    {
      datasets: [
        {
          data: [percentage, 100 - percentage],
          // backgroundColor: ["#B9802A", "#E1BD6B"],
          backgroundColor: ["#d8a32b", "#D9D9D9"],
          borderColor: ["transparent", "transparent"],
        },
      ],
    },
  ];

  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: "top",
      },
      tooltip: {
        enabled: null,
      },
      hover: {
        mode: null,
        animation: false,
      },
      interaction: {
        mode: null,
      },
    },
  };

  useEffect(() => {
    setPercentage(
      (getExperience?.experiance?.length ? 25 : 0) + 
      (getEducation?.education?.length ? 25 : 0) + 
      (getUserDetail?.user?.user_detail?.address ? 50 : 20)
    );
  }, [getExperience, getEducation, getUserDetail]);

  return (
    <div className="sm:flex lg:gap-0 gap-6 justify-between sm:px-2 min-h-dvh z-0">
      <div className="w-full sm:px-5 px-2">
        <Header title="Dashboard" />
        <div className="flex flex-col sm:flex-row my-6 gap-6">
          <div className="bg-white rounded-2xl w-full max-h-full p-6 transition-all duration-300 hover:shadow-[0px_6px_17px_rgba(0,0,0,0.3)]">
            <div className="flex justify-between">
              <h1 className="text-[20px] font-bold mb-4">Profile Completion</h1>
              <Link href="/profile">
                <button className="text-[16px] font-bold">
                  <FontAwesomeIcon
                    icon={faPencil}
                    className="h-5 w-5 text-[#3C4963]"
                  />
                </button>
              </Link>
            </div>
            <div className="overflow-y-auto pr-2 flex gap-3 h-[280px] customScrollbar">
              <div className="w-[200px] flex flex-col gap-3 justify-center">
                <div
                  className={`flex flex-col w-full justify-between items-center`}
                >
                  <h1 className="text-[16px] w-full font-semibold">Profile</h1>
                  <div className="w-full h-[10px] bg-[#D9D9D9] rounded-3xl">
                    <div
                      className="bg-golden rounded-3xl h-[10px]"
                      style={{
                        width: `${
                          getUserDetail?.user?.user_detail?.address ? 100 : 30
                        }%`,
                      }}
                    ></div>
                  </div>
                </div>
                <div
                  className={`flex flex-col w-full justify-between items-center`}
                >
                  <h1 className="text-[16px] w-full font-semibold">
                    Education
                  </h1>
                  <div className="w-full h-[10px] bg-[#D9D9D9] rounded-3xl">
                    <div
                      className="bg-golden rounded-3xl h-[10px]"
                      style={{
                        width: `${getEducation?.education?.length ? 100 : 0}%`,
                      }}
                    ></div>
                  </div>
                </div>
                <div
                  className={`flex flex-col w-full justify-between items-center`}
                >
                  <h1 className="text-[16px] w-full font-semibold">
                    Experience
                  </h1>
                  <div className="w-full h-[10px] bg-[#D9D9D9] rounded-3xl">
                    <div
                      className="bg-golden rounded-3xl h-[10px]"
                      style={{
                        width: `${
                          getExperience?.experiance?.length ? 100 : 0
                        }%`,
                      }}
                    ></div>
                  </div>
                </div>
              </div>
              <div className="flex-1 flex justify-center items-center">
                <div className="relative w-[200px] h-[200px]">
                  <Pie data={pieChartData[0]} options={options} />
                  <span className="absolute text-[28px] font-bold bg-[#fff] w-[100px] h-[100px] mt-1 rounded-full flex items-center justify-center top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                    {percentage}%
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div className="bg-[#FFFFFF] rounded-2xl w-full max-h-full p-6 transition-all duration-300 hover:shadow-[0px_6px_17px_rgba(0,0,0,0.3)]">
            <h1 className="text-[20px] font-bold mb-4">Enrolled Courses</h1>
            <EnrolledDashboardCourses />
          </div>
        </div>
        <div className="flex flex-col sm:flex-row my-6 gap-6">
          {/* <div className="bg-[#FFFFFF] rounded-2xl w-full max-h-full p-6 transition-all duration-300 hover:shadow-[0px_6px_17px_rgba(0,0,0,0.3)]">
            <h1 className="text-[20px] font-bold mb-4">Top Videos</h1>
            <TopVideos />
          </div> */}
          <TopVideos />
          <UpComingVideos />
          {/* <div className="bg-[#FFFFFF] rounded-2xl w-full max-h-full p-6 transition-all duration-300 hover:shadow-[0px_6px_17px_rgba(0,0,0,0.3)]">
            <h1 className="text-[20px] font-bold mb-4">Upcoming Videos</h1>
            <UpComingVideos />
          </div> */}
        </div>
      </div>
    </div>
  );
};

export default Dashoard;
