"use client";
import React, { useEffect, useState } from "react";
import { useFormik } from "formik";
import InputMask from "react-input-mask-next";
import { IMaskInput } from "react-imask";
import * as Yup from "yup";
import toast from "react-hot-toast";
import {
  useGetUserDetailQuery,
  useUpdateUserDetailMutation,
} from "@/services/Api";
import { useDispatch, useSelector } from "react-redux";
import { updateUserProfile } from "@/redux/authSlice";
import { useRouter } from "next/navigation";
import Header from "../../header/header";
import axios from "axios";
import { BASE_URL } from "@/services/ApiEndpoints";

const Information = () => {
  const [loading, setLoading] = useState(false);
  const [profileImage, setProfileImage] = useState("");
  const [image, setImage] = useState(null);
  const [userDetails, setUserDetails] = useState(null);
  const [error, setError] = useState("");
  const [updateUserDetail] = useUpdateUserDetailMutation();
  const dispatch = useDispatch();
  const router = useRouter();
  const [optAImage, setOptAImage] = useState(null);

  let auth = useSelector((item) => item.auth);

  const { data: getUserDetail, refetch: getUserDetailRefetch } =
    useGetUserDetailQuery();

  useEffect(() => {
    setUserDetails(getUserDetail?.user);
  }, [getUserDetail]);

  useEffect(() => {
    getUserDetailRefetch();
  }, []);

  const formik = useFormik({
    initialValues: {
      name: userDetails?.name || "",
      firstname: userDetails?.user_detail.firstname || "",
      lastname: userDetails?.user_detail.lastname || "",
      email: userDetails?.email || "",
      address: userDetails?.user_detail.address || "",
      city: userDetails?.user_detail.city || "",
      country: userDetails?.user_detail.country || "",
      postalcode: userDetails?.user_detail.postalcode || "",
      phoneno: userDetails?.user_detail.phoneno || "",
    },
    enableReinitialize: true,
    validationSchema: Yup.object({
      email: Yup.string()
        .email("Invalid email address")
        .required("Email is required"),
      name: Yup.string().required("Username is required"),
      firstname: Yup.string().required("First Name is required"),
      lastname: Yup.string().required("Last Name is required"),
      address: Yup.string().required("Address is required"),
      city: Yup.string().required("City Name is required"),
      country: Yup.string().required("Country Name is required"),
      postalcode: Yup.string().required("Postal Code is required"),
      phoneno: Yup.string()
        .matches(/^\(\d{3}\)-\d{3}-\d{4}$/, "Phone number is not valid")
        .required("Phone number is required")
        .min(14, "Phone number must be in the format (999)-999-9999"),
    }),

    onSubmit: async (values, { setSubmitting }) => {
      setLoading(true);

      let newData = new FormData();
      newData.append("name", values.name);
      newData.append("firstname", values.firstname);
      newData.append("lastname", values.lastname);
      newData.append("email", values.email);
      newData.append("address", values.address);
      newData.append("city", values.city);
      newData.append("country", values.country);
      newData.append("postalcode", values.postalcode);
      newData.append("phoneno", values.phoneno);

      try {
        const response = await axios.post(
          BASE_URL + "detail/update",
          newData,
          {
            headers: {
              Authorization: `Bearer ${auth.token}`,
              "Content-Type": "application/json",
            },
          }
        );

        // if (!response.ok) {
        //   const errorData = await response.json();
        //   console.error("Server error response:", errorData);
        //   setError(errorData?.message || "Failed to update profile");
        //   toast.error("Profile Not Updated!", {
        //     position: "top-center",
        //   });
        //   return;
        // }

        if (response.data.userDetail) {
          toast.success("Information updated successfully!", {
            position: "top-center",
          });
          router.push("/profile");
          setError("");
        }
      } catch (error) {
        console.error("Fetch error:", error);
        setError(error.message || "An unexpected error occurred");
        toast.error("Profile Not Updated!", {
          position: "top-center",
        });
      } finally {
        setLoading(false);
        setSubmitting(false);
      }
    },
    // onSubmit: async (values, { setSubmitting }) => {
    //   setLoading(true);

    //   let newData = new FormData();
    //   newData.append('name', values.name)
    //   newData.append('firstname', values.firstname)
    //   newData.append('lastname', values.lastname)
    //   newData.append('email', values.email)
    //   newData.append('address', values.address)
    //   newData.append('city', values.city)
    //   newData.append('country', values.country)
    //   newData.append('postalcode', values.postalcode)
    //   newData.append('phoneno', values.phoneno)
    //   newData.append('avatar', image)

    //   try {
    //     // const response = await axios.post('http://172.16.0.196:8000/api/detail/update', newData);
    //     // const response = await fetch(
    //     //   "http://172.16.0.196:8000/api/detail/update",
    //     //   {
    //     //     method: "POST",
    //     //     headers: {
    //     //       Authorization: `Bearer ${auth.token}`,
    //     //       // 'Content-Type': 'application/json'
    //     //     },
    //     //     body: newData,
    //     //   }
    //     // );
    //     const response = await axios.post(
    //       'https://academy.tdtrg.com/api/detail/update',
    //       newData,
    //       {
    //         headers: {
    //           Authorization: `Bearer ${auth.token}`, // Common auth header format
    //         }
    //       }
    //     );
    //     console.log('Response:', response.data);

    //     if (!response.ok) {
    //       const errorData = await response.json();
    //       console.error("Server error response:", errorData);
    //       setError(errorData?.message || "Failed to update profile");
    //       toast.error("Profile Not Updated!", {
    //         position: "top-center",
    //       });
    //       return;
    //     }

    //     const data = await response.json();
    //     console.log("Success response:", data);

    //     toast.success("Information updated successfully!", {
    //       position: "top-center",
    //     });
    //     router.push("/profile");
    //     setError("");
    //   } catch (error) {
    //     console.error("Fetch error:", error);
    //     setError(error.message || "An unexpected error occurred");
    //     toast.error("Profile Not Updated!", {
    //       position: "top-center",
    //     });
    //   } finally {
    //     setLoading(false);
    //     setSubmitting(false);
    //   }
    // },
  });

  const handleImageChange = async (event) => {
    const file = event.target.files[0];

    let newData = new FormData();
    newData.append("avatar", file);

    if (!file) return;

    // Validate file type
    const allowedTypes = ["image/jpeg", "image/png", "image/gif"];
    if (!allowedTypes.includes(file.type)) {
      toast.error("Only JPEG, PNG, or GIF files are allowed!", {
        position: "top-center",
      });
      return;
    }

    const maxSizeInBytes = 5 * 1024 * 1024;
    if (file.size > maxSizeInBytes) {
      toast.error("File size must be less than 5MB!", {
        position: "top-center",
      });
      return;
    }

    setOptAImage(file);
    setImage(file);
    setProfileImage(file);

    toast.success("Profile Image Uploading...", {
      position: "top-center",
    });

    try {
      const response = await fetch(
        BASE_URL + "update-profile-image",
        {
          method: "POST",
          headers: {
            Authorization: `Bearer ${auth.token}`,
          },
          body: newData,
        }
      );
      if (!response.ok) throw new Error("Failed to fetch enrolled courses");
      let data = await response.json();

      toast.success(data.message, {
        position: "top-center",
      });

      router.push("/profile");
    } catch (error) {
      console.log(error);

      // toast.error("Profile Not Updated!", {
      //   position: "top-center",
      // });
      throw error;
    }
  };

  return (
    <div className="md:px-10 px-6 min-h-screen">
      <Header title="Edit Profile" />
      <div className="bg-white rounded-2xl p-4 mt-6 lg:p-8">
        <h1 className="text-2xl font-bold">Personal Information</h1>
        <form onSubmit={formik.handleSubmit} className="mt-8">
          <div className="flex flex-col-reverse md:flex-row gap-6 justify-between">
            <div className="md:w-2/3 grid grid-cols-2 gap-6">
              <div className="flex flex-col gap-2">
                <label className="text-[16px] font-bold">First Name</label>
                <input
                  type="text"
                  name="firstname"
                  value={formik.values.firstname}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  onFocus={formik.handleFocus}
                  placeholder="Enter your first name"
                  className={`outline-none border rounded-lg px-3 py-3 bg-white ${
                    formik.touched.firstname && formik.errors.firstname
                      ? "border-red-500"
                      : "border-gray-700 focus:border-golden"
                  }`}
                />
                {formik.touched.firstname && formik.errors.firstname ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.firstname}
                  </div>
                ) : null}
              </div>
              <div className="flex flex-col gap-2">
                <label className="text-[16px] font-bold">Last Name</label>
                <input
                  type="text"
                  name="lastname"
                  value={formik.values.lastname}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  onFocus={formik.handleFocus}
                  placeholder="Enter your last name"
                  className={`outline-none border rounded-lg px-3 py-3 bg-white ${
                    formik.touched.lastname && formik.errors.lastname
                      ? "border-red-500"
                      : "border-gray-700 focus:border-golden"
                  }`}
                />
                {formik.touched.lastname && formik.errors.lastname ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.lastname}
                  </div>
                ) : null}
              </div>
              <div className="flex flex-col gap-2">
                <label className="text-[16px] font-bold">User Name</label>
                <input
                  type="text"
                  name="name"
                  value={formik.values.name}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  onFocus={formik.handleFocus}
                  placeholder="Enter username"
                  disabled
                  className={`outline-none border rounded-lg px-3 py-3 bg-white opacity-50 ${
                    formik.touched.name && formik.errors.name
                      ? "border-red-500"
                      : "border-gray-700 focus:border-golden"
                  }`}
                />
                {formik.touched.name && formik.errors.name ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.name}
                  </div>
                ) : null}
              </div>
              <div className="flex flex-col gap-2">
                <label className="text-[16px] font-bold">Email Address</label>
                <input
                  type="email"
                  name="email"
                  value={formik.values.email}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  onFocus={formik.handleFocus}
                  placeholder="Enter your email address"
                  disabled
                  className={`outline-none border rounded-lg px-3 py-3 bg-white opacity-50 ${
                    formik.touched.email && formik.errors.email
                      ? "border-red-500"
                      : "border-gray-700 focus:border-golden"
                  }`}
                />
                {formik.touched.email && formik.errors.email ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.email}
                  </div>
                ) : null}
              </div>
            </div>

            <div className="flex flex-col justify-center md:justify-start md:items-center items-center gap-6 xl:mr-8">
              <div className="flex flex-col justify-center items-center gap-6 xl:mr-8">
                {profileImage || userDetails?.media[0]?.original_url ? (
                  <img
                    src={
                      profileImage
                        ? profileImage
                        : userDetails?.media[0]?.original_url
                    }
                    className="rounded-full h-36 w-36"
                    alt="User Profile"
                  />
                ) : (
                  <div className="rounded-full h-36 w-36 bg-golden text-white text-5xl font-bold flex items-center justify-center">
                    {formik.values.email ? (
                      formik.values.email.charAt(0).toUpperCase()
                    ) : (
                      <div className="text-xl">No Image</div>
                    )}
                  </div>
                )}
                <div>
                  <label
                    htmlFor="avatar"
                    className="border border-gray-700 focus:border-golden rounded-lg px-3 py-3 bg-[#FFFAFA] cursor-pointer"
                  >
                    Upload Profile
                  </label>
                  <input
                    id="avatar"
                    type="file"
                    accept="image/jpeg,image/png,image/gif"
                    onChange={handleImageChange}
                    className="hidden"
                  />
                </div>
              </div>
            </div>
          </div>

          <div className="lg:w-2/3 mt-10">
            <h1 className="text-2xl font-bold">Contact Information</h1>
            <div className="mt-10">
              <div>
                <div className="flex flex-col justify-between md:flex-row lg:gap-8 gap-3">
                  <div className="flex flex-col gap-2 md:w-2/3">
                    <label className="text-[16px] font-bold">Address</label>
                    <input
                      type="image/jpeg,image/png,image/gif"
                      name="address"
                      value={formik.values.address}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                      onFocus={formik.handleFocus}
                      placeholder="Enter your address"
                      className={`outline-none border rounded-lg px-3 py-3 bg-white ${
                        formik.touched.address && formik.errors.address
                          ? "border-red-500"
                          : "border-gray-700 focus:border-golden"
                      }`}
                    />
                    {formik.touched.address && formik.errors.address ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.address}
                      </div>
                    ) : null}
                  </div>

                  <div className="flex flex-col gap-2 md:w-1/3">
                    <label className="text-[16px] font-bold">City</label>
                    <input
                      type="text"
                      name="city"
                      value={formik.values.city}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                      onFocus={formik.handleFocus}
                      placeholder="Enter your city name"
                      className={`outline-none border rounded-lg px-3 py-3 bg-white ${
                        formik.touched.city && formik.errors.city
                          ? "border-red-500"
                          : "border-gray-700 focus:border-golden"
                      }`}
                    />
                    {formik.touched.city && formik.errors.city ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.city}
                      </div>
                    ) : null}
                  </div>
                </div>

                <div className="flex flex-col md:flex-row justify-between lg:gap-8 gap-3 mt-6">
                  <div className="flex flex-col md:flex-row gap-4 md:w-2/3">
                    <div className="flex flex-col gap-2 md:w-1/2 w-full">
                      <label className="text-[16px] font-bold">Country</label>
                      <input
                        type="text"
                        name="country"
                        value={formik.values.country}
                        onChange={formik.handleChange}
                        onBlur={formik.handleBlur}
                        onFocus={formik.handleFocus}
                        placeholder="Enter country name"
                        className={`outline-none border rounded-lg px-3 py-3 bg-white ${
                          formik.touched.country && formik.errors.country
                            ? "border-red-500"
                            : "border-gray-700 focus:border-golden"
                        }`}
                      />
                      {formik.touched.country && formik.errors.country ? (
                        <div className="text-red-500 text-sm">
                          {formik.errors.country}
                        </div>
                      ) : null}
                    </div>

                    <div className="flex flex-col gap-2 md:w-1/2">
                      <label className="text-[16px] font-bold">Phone</label>
                      {/* <InputMask
                        mask="(999)-999-9999"
                        value={formik.values.phoneno}
                        onChange={(e) =>
                          formik.setFieldValue("phoneno", e.target.value)
                        }
                        onBlur={formik.handleBlur}
                        onFocus={formik.handleFocus}
                      >
                        {(inputProps) => (
                          <input
                            {...inputProps}
                            type="text"
                            name="phoneno"
                            minLength={14}
                            placeholder="Enter phone number"
                            className={`outline-none border rounded-lg px-3 py-3 bg-white opacity-50 ${
                              formik.touched.phoneno && formik.errors.phoneno
                                ? "border-red-500"
                                : "border-gray-700 focus:border-golden"
                            }`}
                          />
                        )}
                      </InputMask>
                      {formik.touched.phoneno && formik.errors.phoneno ? (
                        <div className="text-red-500 text-sm">
                          {formik.errors.phoneno}
                        </div>
                      ) : null} */}
                      <IMaskInput
                        mask="(000)-000-0000"
                        value={formik.values.phoneno}
                        onAccept={(value) =>
                          formik.setFieldValue("phoneno", value)
                        } // Handle changes
                        onBlur={formik.handleBlur}
                        name="phoneno"
                        className="outline-none border rounded-lg px-3 py-3 bg-white border-gray-700"
                      />
                      {formik.touched.phoneno && formik.errors.phoneno ? (
                        <div className="text-red-500 text-sm">
                          {formik.errors.phoneno}
                        </div>
                      ) : null}
                    </div>
                  </div>
                  <div className="flex flex-col gap-2 md:w-1/3">
                    <label className="text-[16px] font-bold">Postal Code</label>
                    <input
                      type="text"
                      name="postalcode"
                      value={formik.values.postalcode}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                      onFocus={formik.handleFocus}
                      placeholder="Enter your postal code"
                      className={`outline-none border rounded-lg px-3 py-3 bg-white ${
                        formik.touched.postalcode && formik.errors.postalcode
                          ? "border-red-500"
                          : "border-gray-700 focus:border-golden"
                      }`}
                    />
                    {formik.touched.postalcode && formik.errors.postalcode ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.postalcode}
                      </div>
                    ) : null}
                  </div>
                </div>
              </div>
            </div>
          </div>
          {error && (
            <div className="text-red-500 text-base text-center my-4">
              {error}
            </div>
          )}
          <div className="flex justify-end mt-6">
            <button
              type="submit"
              className="bg-golden rounded-xl px-6 text-white font-medium py-2"
            >
              {loading ? "Loading..." : "Submit"}
            </button>
          </div>
        </form>
      </div>
    </div>
  );
};

export default Information;
