import React from "react";
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faPlay } from '@fortawesome/free-solid-svg-icons';

function HomeCard() {
  return (
    <div>
      <div className="relative">
        <img
          src="/assets/home/homeCard.png"
          alt="Home-Card"
          className="w-full min-h-[300px] max-h-[912px] bg-cover"
        />
        <div className="absolute top-0 left-0 h-full w-full flex justify-center items-end">
          <button className="mb-8 border-2 border-white p-3 gap-3 lg:py-4 lg:px-6 rounded-full flex items-center uppercase text-white bg-slate-800 bg-opacity-50">
          <FontAwesomeIcon icon={faPlay} size="lg" />
            Watch More Videos
          </button>
        </div>
      </div>
    </div>
  );
}

export default HomeCard;