import { configureStore } from "@reduxjs/toolkit";
import {
  persistStore,
  FLUSH,
  REHYDRATE,
  PAUSE,
  PERSIST,
  PURGE,
  REGISTER,
} from "redux-persist";
import { api } from "../services/Api";
import authSlice from "./authSlice";
import courseProgressReducerSlice from "@/newStore/features/courseProgresSlice";
import inProgressReducerSlice from "@/newStore/features/inProgressSlice";
import courseCompletedReducerSlice from "@/newStore/features/courseCompletedSlice";
import upComingVideoReducerSlice from "@/newStore/features/upComingVideoSlice";
import topVideosReducerSlice from "@/newStore/features/topVideosSlice";
import assignmentTaskReducerSlice from "@/newStore/features/assignmentTaskSlice";
import getAllCourseSlice from "@/newStore/features/getAllCourseSlice";
import courseToEnrolledSlice from "@/newStore/features/courseToEnrolled";
import enrolledCoursesSlice from "@/newStore/features/enrolledCoursesSlice";
import videoSlice from "@/redux/videoSlice";

export const store = configureStore({
  reducer: {
    auth: authSlice,
    courseProgress: courseProgressReducerSlice,
    inProgress: inProgressReducerSlice,
    courseCompleted: courseCompletedReducerSlice,
    upComingVideo: upComingVideoReducerSlice,
    topVideos: topVideosReducerSlice,
    assignmentTask: assignmentTaskReducerSlice,
    getAllCourse: getAllCourseSlice,
    enrolledCourses: enrolledCoursesSlice,
    courseToEnroll: courseToEnrolledSlice,
    sendVideoWatchTime: videoSlice,
    [api.reducerPath]: api.reducer,
  },
  middleware: (getDefaultMiddleware) =>
    getDefaultMiddleware({
      serializableCheck: {
        ignoredActions: [FLUSH, REHYDRATE, PAUSE, PERSIST, PURGE, REGISTER],
      },
    }).concat(api.middleware),
});

export let persistor = persistStore(store);